import { Path, Rect, SVG } from '@wordpress/components';

export const siteIdentity = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path d="M17 22H5a2.982 2.982 0 0 1-2.121-.879A2.978 2.978 0 0 1 2 19v-4c0-.801.312-1.555.879-2.121a2.98 2.98 0 0 1 2.046-.878l-.288-.288a2.98 2.98 0 0 1-.879-2.121c0-.801.312-1.554.879-2.121l2.828-2.828c1.133-1.133 3.109-1.133 4.242 0l.293.294a2.984 2.984 0 0 1 .878-2.058A2.982 2.982 0 0 1 15 2h4c.801 0 1.555.312 2.121.879.567.566.879 1.32.879 2.121v12c0 1.335-.521 2.591-1.465 3.535S18.335 22 17 22zm0-2c.789 0 1.563-.32 2.121-.879S20 17.789 20 17V5a1.003 1.003 0 0 0-1-1h-4a1.003 1.003 0 0 0-1 1v12c0 .789.32 1.563.879 2.121S16.211 20 17 20zM5 14a1.003 1.003 0 0 0-1 1v4a1.003 1.003 0 0 0 1 1h7.924l-6-6H5zm4.586-8.235a.996.996 0 0 0-.707.292L6.051 8.885a.993.993 0 0 0-.293.707c0 .263.107.521.293.707L12 16.248V7.764l-1.707-1.707a.996.996 0 0 0-.707-.292zM17 18.01a1.003 1.003 0 0 1 0-2.005c.553 0 1 .442 1 .995v.01a1 1 0 0 1-1 1z" />
	</SVG>
);

export const mainHeader = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path
			fillRule="evenodd"
			d="M3.763 3.268A1.75 1.75 0 0 1 5 2.755h14a1.75 1.75 0 0 1 1.75 1.75v5a.75.75 0 0 1-.75.75H4a.75.75 0 0 1-.75-.75v-5c0-.464.184-.91.513-1.237ZM5 4.255a.25.25 0 0 0-.25.25v4.25h14.5v-4.25a.25.25 0 0 0-.25-.25H5Zm-1 9.49a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Zm16 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Zm-16 5a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Zm5 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Zm6 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Zm5 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0v-.01a.75.75 0 0 1 .75-.75Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const footerColumn = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path
			fillRule="evenodd"
			d="M4 3.25a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V4A.75.75 0 0 1 4 3.25Zm5 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V4A.75.75 0 0 1 9 3.25Zm6 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V4a.75.75 0 0 1 .75-.75Zm5 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V4a.75.75 0 0 1 .75-.75Zm-16 5a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V9A.75.75 0 0 1 4 8.25Zm16 0a.75.75 0 0 1 .75.75v.01a.75.75 0 0 1-1.5 0V9a.75.75 0 0 1 .75-.75ZM3.25 14a.75.75 0 0 1 .75-.75h16a.75.75 0 0 1 .75.75v5A1.75 1.75 0 0 1 19 20.75H5A1.75 1.75 0 0 1 3.25 19v-5Zm1.5.75V19a.25.25 0 0 0 .25.25h14a.25.25 0 0 0 .25-.25v-4.25H4.75Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const Colors = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path
			fillRule="evenodd"
			d="M12 3.75a8.25 8.25 0 1 0 0 16.5c.023 0 .046.001.068.003a.55.55 0 0 0 .468-.905 2.75 2.75 0 0 1 1.47-5.098H16.5c1.02 0 1.985-.362 2.684-.983.695-.618 1.066-1.436 1.066-2.267 0-3.923-3.609-7.25-8.25-7.25ZM5.106 5.106A9.75 9.75 0 0 1 12 2.25c5.299 0 9.75 3.837 9.75 8.75 0 1.29-.577 2.507-1.57 3.389-.99.879-2.314 1.361-3.68 1.361h-2.512a1.25 1.25 0 0 0-.625 2.344.745.745 0 0 1 .146.105 2.05 2.05 0 0 1-1.54 3.551A9.75 9.75 0 0 1 5.106 5.106Zm6.157 1.157a1.75 1.75 0 1 1 2.474 2.474 1.75 1.75 0 0 1-2.474-2.474Zm1.237.987a.25.25 0 1 0 0 .5.25.25 0 0 0 0-.5ZM7.263 9.263a1.75 1.75 0 1 1 2.474 2.474 1.75 1.75 0 0 1-2.474-2.474Zm1.237.987a.25.25 0 1 0 0 .5.25.25 0 0 0 0-.5Zm6.763-.987a1.75 1.75 0 1 1 2.474 2.474 1.75 1.75 0 0 1-2.474-2.474Zm1.237.987a.25.25 0 1 0 0 .5.25.25 0 0 0 0-.5Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const Sidebar = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path
			fillRule="evenodd"
			d="M13.992 3.752a.75.75 0 0 1 .75-.75h.01a.75.75 0 0 1 0 1.5h-.01a.75.75 0 0 1-.75-.75Zm5 0a.75.75 0 0 1 .75-.75h.011a.75.75 0 0 1 0 1.5h-.011a.75.75 0 0 1-.75-.75ZM3.515 3.516a1.75 1.75 0 0 1 1.237-.513h5a.75.75 0 0 1 .75.75v16a.75.75 0 0 1-.75.75h-5a1.75 1.75 0 0 1-1.75-1.75v-14c0-.464.184-.91.513-1.237Zm1.237.987a.25.25 0 0 0-.25.25v14a.25.25 0 0 0 .25.25h4.25v-14.5h-4.25Zm14.24 4.249a.75.75 0 0 1 .75-.75h.011a.75.75 0 0 1 0 1.5h-.011a.75.75 0 0 1-.75-.75Zm0 6a.75.75 0 0 1 .75-.75h.011a.75.75 0 0 1 0 1.5h-.011a.75.75 0 0 1-.75-.75Zm-5 5.001a.75.75 0 0 1 .75-.75h.01a.75.75 0 0 1 0 1.5h-.01a.75.75 0 0 1-.75-.75Zm5 0a.75.75 0 0 1 .75-.75h.011a.75.75 0 0 1 0 1.5h-.011a.75.75 0 0 1-.75-.75Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const Blog = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 24 24"
		width="24px"
		height="24px"
	>
		<Path
			fillRule="evenodd"
			d="M5 6.25A1.25 1.25 0 0 0 3.75 7.5v.75H4A1.75 1.75 0 1 1 2.25 10V7.5A2.75 2.75 0 0 1 5 4.75a.75.75 0 0 1 0 1.5Zm-1.25 3.5V10A.25.25 0 1 0 4 9.75h-.25ZM11 6.25A1.25 1.25 0 0 0 9.75 7.5v.75H10A1.75 1.75 0 1 1 8.25 10V7.5A2.75 2.75 0 0 1 11 4.75a.75.75 0 0 1 0 1.5Zm-1.25 3.5V10a.25.25 0 1 0 .25-.25h-.25ZM14.25 7a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5h-6a.75.75 0 0 1-.75-.75Zm0 4a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5h-6a.75.75 0 0 1-.75-.75Zm-9 4a.75.75 0 0 1 .75-.75h15a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1-.75-.75Zm0 4a.75.75 0 0 1 .75-.75h15a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1-.75-.75Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const documentIcon = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 14 14"
		width="16px"
		height="16px"
	>
		<Path
			fillRule="evenodd"
			d="M1.94 1.44A1.5 1.5 0 0 1 3 1h4.25a.5.5 0 0 1 .354.146l2.75 2.75a.5.5 0 0 1 .146.354v6.25A1.5 1.5 0 0 1 9 12H3a1.5 1.5 0 0 1-1.5-1.5v-8c0-.398.158-.78.44-1.06ZM3 2a.5.5 0 0 0-.5.5v8a.5.5 0 0 0 .5.5h6a.5.5 0 0 0 .5-.5V4.457L7.043 2H3Z"
			clipRule="evenodd"
		/>
		<Path
			fillRule="evenodd"
			d="M7 1a.5.5 0 0 1 .5.5V4H10a.5.5 0 0 1 0 1H7a.5.5 0 0 1-.5-.5v-3A.5.5 0 0 1 7 1Z"
			clipRule="evenodd"
		/>
	</SVG>
);

export const tickMark = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 16 16"
		width="16px"
		height="16px"
		fill="none"
	>
		<Path
			d="M5.37994 11.5537L5.7335 11.9073L6.08705 11.5537L13.887 3.75375C13.9296 3.71119 13.9703 3.7002 14.0002 3.7002C14.03 3.7002 14.0707 3.71119 14.1133 3.75375C14.1558 3.79631 14.1668 3.83698 14.1668 3.86686C14.1668 3.89675 14.1558 3.93742 14.1133 3.97998L5.84661 12.2466C5.80946 12.2838 5.79218 12.2918 5.78876 12.2933L5.7886 12.2934C5.78668 12.2943 5.7738 12.3002 5.7335 12.3002C5.6932 12.3002 5.68032 12.2943 5.67839 12.2934L5.67823 12.2933C5.67482 12.2918 5.65753 12.2838 5.62038 12.2466L1.88705 8.51331C1.84449 8.47075 1.8335 8.43008 1.8335 8.4002C1.8335 8.37031 1.84449 8.32964 1.88705 8.28708L1.54017 7.9402L1.88705 8.28708C1.92961 8.24452 1.97028 8.23353 2.00016 8.23353C2.03005 8.23353 2.07072 8.24452 2.11328 8.28708L5.37994 11.5537Z"
			fill="#222222"
			stroke="#219653"
		/>
	</SVG>
);

export const changeLogMark = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 16 16"
		width="12px"
		height="12px"
		fill="none"
	>
		<Path
			d="M5.37994 11.5537L5.7335 11.9073L6.08705 11.5537L13.887 3.75375C13.9296 3.71119 13.9703 3.7002 14.0002 3.7002C14.03 3.7002 14.0707 3.71119 14.1133 3.75375C14.1558 3.79631 14.1668 3.83698 14.1668 3.86686C14.1668 3.89675 14.1558 3.93742 14.1133 3.97998L5.84661 12.2466C5.80946 12.2838 5.79218 12.2918 5.78876 12.2933L5.7886 12.2934C5.78668 12.2943 5.7738 12.3002 5.7335 12.3002C5.6932 12.3002 5.68032 12.2943 5.67839 12.2934L5.67823 12.2933C5.67482 12.2918 5.65753 12.2838 5.62038 12.2466L1.88705 8.51331C1.84449 8.47075 1.8335 8.43008 1.8335 8.4002C1.8335 8.37031 1.84449 8.32964 1.88705 8.28708L1.54017 7.9402L1.88705 8.28708C1.92961 8.24452 1.97028 8.23353 2.00016 8.23353C2.03005 8.23353 2.07072 8.24452 2.11328 8.28708L5.37994 11.5537Z"
			fill="#222222"
			stroke="gray"
		/>
	</SVG>
);

export const crossMark = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		viewBox="0 0 16 16"
		width="16px"
		height="16px"
		fill="none"
	>
		<Path
			fillRule="evenodd"
			clipRule="evenodd"
			d="M12.7071 4.70711C13.0976 4.31658 13.0976 3.68342 12.7071 3.29289C12.3166 2.90237 11.6834 2.90237 11.2929 3.29289L8 6.58579L4.70711 3.29289C4.31658 2.90237 3.68342 2.90237 3.29289 3.29289C2.90237 3.68342 2.90237 4.31658 3.29289 4.70711L6.58579 8L3.29289 11.2929C2.90237 11.6834 2.90237 12.3166 3.29289 12.7071C3.68342 13.0976 4.31658 13.0976 4.70711 12.7071L8 9.41421L11.2929 12.7071C11.6834 13.0976 12.3166 13.0976 12.7071 12.7071C13.0976 12.3166 13.0976 11.6834 12.7071 11.2929L9.41421 8L12.7071 4.70711Z"
			fill="#97022E"
		/>
	</SVG>
);

export const everestForm = (
	<SVG
		xmlns="http://www.w3.org/2000/svg"
		width="40"
		height="40"
		viewBox="0 0 41 40"
		fill="none"
	>
		<Rect x="0.5" width="40" height="40" rx="3.63636" fill="#5317AA" />
		<Path
			d="M27.309 11.1045H22.9999L24.3223 13.3268H28.6186L27.309 11.1045Z"
			fill="white"
		/>
		<Path
			d="M30.0183 15.5527H25.7156L27.1025 17.7751H31.4085L30.0183 15.5527Z"
			fill="white"
		/>
		<Path
			d="M29.9506 26.6704H13.5493L20.4292 15.4136L23.2772 20.0002H20.4292L19.11 22.2225H27.2412L20.4292 11.2432L9.5885 28.8959H31.3408L29.9506 26.6704Z"
			fill="white"
		/>
	</SVG>
);

export const userRegistration = (
	<SVG
		viewBox="0 0 40 40"
		width="40"
		height="40"
		xmlns="https://www.w3.org/2000/svg"
		className="css-1ngw63v"
	>
		<Path
			fill="#475BB2"
			d="M0 3.636A3.636 3.636 0 0 1 3.636 0h32.728A3.636 3.636 0 0 1 40 3.636v32.728A3.636 3.636 0 0 1 36.364 40H3.636A3.636 3.636 0 0 1 0 36.364V3.636Z"
		/>
		<Path
			fill="#fff"
			d="M28.99 10.623c-1.45.852-2.813 1.96-4.006 3.154-1.194 1.193-2.301 2.556-3.154 3.92a27.715 27.715 0 0 1 1.534 3.665c.767-1.62 1.705-3.068 2.898-4.347v4.602a6.29 6.29 0 0 1-4.602 6.052h-.17c-.171-2.216-.682-4.347-1.45-6.393a21.151 21.151 0 0 0-5.028-7.5c-1.193-1.193-2.557-2.215-4.006-3.153l-.34-.17v11.08c0 4.516 3.238 8.437 7.755 9.204h.085c1.023.17 2.046.17 2.983 0h.086c4.517-.767 7.755-4.688 7.755-9.205v-11.08l-.34.171Zm-15.256 10.91v-4.518c2.642 2.983 4.261 6.648 4.602 10.568a6.29 6.29 0 0 1-4.602-6.05Zm6.221-12.444a2.292 2.292 0 0 0-2.3 2.301 2.292 2.292 0 0 0 2.3 2.301 2.292 2.292 0 0 0 2.301-2.3 2.292 2.292 0 0 0-2.3-2.302Z"
		/>
	</SVG>
);

export const masteriyo = (
	<SVG
		viewBox="0 0 40 40"
		width="40"
		height="40"
		xmlns="https://www.w3.org/2000/svg"
		className="css-1ngw63v"
	>
		<Rect width="40" height="40" fill="#E9E3FD" rx="3.636" />
		<Path
			fill="#787DFF"
			d="m14.163 11.898 3.851 4.281c.607.64.946 1.489.946 2.37v10.009l-4.8-3.353.003-13.307Z"
			opacity=".3"
		/>
		<Path
			fill="#787DFF"
			d="m11.173 11.3 6.346 4.519a3.373 3.373 0 0 1 1.438 2.559V28.55l-7.785-4.102.001-13.148Z"
			opacity=".5"
		/>
		<Path
			fill="#787DFF"
			d="m18.96 28.656-7.014-2.245A3.48 3.48 0 0 1 9.5 23.305V12.953l7.62 2.943a2.831 2.831 0 0 1 1.835 2.452v.16l.005 10.148Z"
		/>
		<Path
			fill="#FD739C"
			d="m25.837 11.898-3.851 4.281a3.444 3.444 0 0 0-.946 2.364v10.008l4.8-3.353-.003-13.3Z"
			opacity=".3"
		/>
		<Path
			fill="#FD739C"
			d="m28.828 11.3-6.346 4.519a3.374 3.374 0 0 0-1.438 2.559V28.55l7.785-4.102-.001-13.148Z"
			opacity=".5"
		/>
		<Path
			fill="#FD739C"
			d="m21.04 28.656 7.013-2.245c1.373-.44 2.377-1.667 2.447-3.106V12.953l-7.617 2.943a2.832 2.832 0 0 0-1.836 2.452v.16l-.007 10.148Z"
		/>
	</SVG>
);

export const magazineBlocks = (
	<SVG
		viewBox="0 0 40 40"
		width="40"
		height="40"
		xmlns="https://www.w3.org/2000/svg"
		className="css-1ngw63v"
	>
		<Rect width="40" height="40" fill="#8D42CE" rx="3.636" />
		<Path
			fill="#fff"
			d="M19.781 26.7h-7.025V13.797l7.025 4.387V26.7Zm7.01 0h-7.01v-8.517l7.01-4.387V26.7Z"
		/>
		<Path
			fill="#fff"
			d="M30.077 30.576h-21V9.5h21v21.076Zm-20.05-.95h19.115V10.45H10.027v19.176Z"
		/>
	</SVG>
);
